/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.psg;

import frc.emul.api.ILogger;
import frc.emul.api.persistence.IPersistenceReader;
import frc.emul.api.persistence.IPersistenceWriter;
import frc.emul.api.persistence.IPersistentObject;
import frc.emul.api.persistence.IPersistentSection;
import frc.emul.api.persistence.PersistenceException;
import frc.emul.config.Configuration;
import frc.emul.config.data.DevOptions;
import frc.emul.psg.AY38912;
import frc.emul.psg.AudioLine;
import frc.emul.psg.DacOutputLine;
import frc.emul.psg.IAudioSettings;
import frc.emul.psg.IExtraAudioLine;
import frc.emul.psg.IPsgCore;
import frc.emul.psg.IVectrexAudio;
import frc.emul.psg.dev.TimedUpdater;
import frc.emul.psg.dev.ui.SamplesMonitor;
import frc.emul.vectrex.PersistentSection;
import frc.emul.via6522.I6522InternalLines;

public final class VectrexAudio
implements IVectrexAudio,
IAudioSettings,
IPersistentObject {
    private long lastRenderMS;
    private long lastRenderNS;
    private static final long CLOCK_FREQ = 1500000L;
    private static final String UPDATE_THREAD_NAME = "ParaJVE - Sound Updater";
    private static final int UPDATE_FREQ = 60;
    private transient boolean threaded;
    private transient boolean paused;
    private Configuration conf;
    private DacOutputLine dacLine;
    private AudioLine line;
    private IPsgCore psg;
    private IExtraAudioLine extraLine;
    TimedUpdater updaterThread;
    private boolean[] mutedChannels = new boolean[3];

    public VectrexAudio(Configuration configuration, ILogger iLogger, I6522InternalLines i6522InternalLines) {
        this.createCore(configuration, iLogger, i6522InternalLines);
        if (DevOptions.monitorPSG) {
            SamplesMonitor.monitorPSG(this.getPSG());
        }
    }

    private VectrexAudio() {
        this.conf = new Configuration();
        this.createCore(this.conf, null, null);
    }

    private void createCore(Configuration configuration, ILogger iLogger, I6522InternalLines i6522InternalLines) {
        this.conf = configuration;
        this.threaded = configuration.options.snd_createThread;
        this.dacLine = new DacOutputLine();
        this.line = new AudioLine(this.dacLine, this);
        this.psg = new AY38912(iLogger, i6522InternalLines);
        this.setSoundEnabled(configuration.options.snd_enabled);
    }

    public static VectrexAudio createTestInstance() {
        return new VectrexAudio();
    }

    public float getVolumeLevel() {
        return this.conf.options.snd_volume;
    }

    public int getSampleRate() {
        return this.conf.options.snd_samplingFreq;
    }

    public int getUpdatesPerSecond() {
        return 20;
    }

    public long getClockRate() {
        return 1500000L;
    }

    public boolean isChannelAMuted() {
        return this.mutedChannels[0];
    }

    public boolean isChannelBMuted() {
        return this.mutedChannels[1];
    }

    public boolean isChannelCMuted() {
        return this.mutedChannels[2];
    }

    public final IPsgCore getPSG() {
        return this.psg;
    }

    public final boolean isSoundEnabled() {
        return !this.psg.isMute();
    }

    public final void setSoundEnabled(boolean bl) {
        this.line.setMute(!bl);
        this.psg.setMute(!bl);
    }

    public final void setExtraLine(IExtraAudioLine iExtraAudioLine) {
        if (iExtraAudioLine != null) {
            iExtraAudioLine.updateSettings(this);
        }
        this.extraLine = iExtraAudioLine;
    }

    public final boolean isChannelMuted(int n) {
        return this.mutedChannels[n];
    }

    public final void setChannelMuted(int n, boolean bl) {
        if (bl != this.isChannelMuted(n)) {
            this.mutedChannels[n] = bl;
            this.psg.updateSettings(this);
        }
    }

    public void setPaused(boolean bl) {
        if (this.paused != bl) {
            this.paused = bl;
            if (this.updaterThread != null) {
                this.updaterThread.setPaused(bl);
            }
            if (bl) {
                this.line.clear();
            }
        }
    }

    public final void tick(int n) {
        this.dacLine.tick(n);
    }

    public final void frameUpdate() {
        if (this.threaded) {
            if (this.isSoundEnabled()) {
                if (this.updaterThread != null) {
                    return;
                }
                this.updaterThread = new TimedUpdater(UPDATE_THREAD_NAME, 60.0){

                    public void update() {
                        VectrexAudio.this.render();
                    }

                    public void updaterCompleted() {
                        VectrexAudio.this.updaterThread = null;
                    }
                };
                this.updaterThread.setPriority(10);
                this.updaterThread.start();
            }
        } else {
            this.render();
        }
    }

    public final void render() {
        if (!this.paused) {
            if (this.conf.options.snd_useNano) {
                this.renderNS();
            } else {
                this.renderMS();
            }
        }
    }

    private final void renderMS() {
        long l = System.currentTimeMillis();
        float f = l - this.lastRenderMS;
        if (this.lastRenderMS >= 0L) {
            this.line.render(f, this.psg, this.extraLine);
        }
        this.lastRenderMS = l;
    }

    private final void renderNS() {
        long l = System.nanoTime();
        double d = l - this.lastRenderNS;
        if (this.lastRenderNS >= 0L) {
            this.line.render((float)(d / 1000000.0), this.psg, this.extraLine);
        }
        this.lastRenderNS = l;
    }

    public final synchronized void updateSettings() {
        if (this.updaterThread != null) {
            this.updaterThread.shutdown();
        }
        this.psg.updateSettings(this);
        this.line.updateSettings(this);
        if (this.extraLine != null) {
            this.extraLine.updateSettings(this);
        }
    }

    public final synchronized void initialise() {
        this.psg.initialise(this);
        this.line.initialise();
    }

    public final synchronized void reset() {
        this.line.reset();
        this.psg.reset();
    }

    public final synchronized void shutdown() {
        this.line.shutdown();
        if (this.updaterThread != null) {
            this.updaterThread.shutdown();
        }
    }

    public final void outputDAC(int n) {
        this.dacLine.outputDAC(n);
    }

    public IPersistentSection getSection() {
        return PersistentSection.AUDIO;
    }

    public void store(IPersistenceWriter iPersistenceWriter) throws PersistenceException {
        iPersistenceWriter.write(this.psg);
        iPersistenceWriter.write(this.dacLine);
    }

    public void load(IPersistenceReader iPersistenceReader) throws PersistenceException {
        this.line.clear();
        iPersistenceReader.read(this.psg);
        iPersistenceReader.read(this.dacLine);
    }
}

